/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.chickens.item;

import java.util.List;
import java.util.function.Consumer;
import net.creeperhost.chickens.client.render.RenderChickenItem;
import net.creeperhost.chickens.data.ChickenStats;
import net.creeperhost.chickens.item.ItemSpawnEgg;
import net.creeperhost.chickens.registry.ChickensRegistry;
import net.creeperhost.chickens.registry.ChickensRegistryItem;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.IItemRenderProperties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemChicken
extends Item {
    public ItemChicken(Item.Properties properties) {
        super(properties);
    }

    public void m_6787_(@NotNull CreativeModeTab tab, @NotNull NonNullList<ItemStack> subItems) {
        if (this.m_41389_(tab)) {
            for (ChickensRegistryItem chicken : ChickensRegistry.getItems()) {
                ItemStack itemstack = new ItemStack((ItemLike)this);
                ItemChicken.applyEntityIdToItemStack(itemstack, chicken.getRegistryName());
                subItems.add((Object)itemstack);
            }
        }
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext useOnContext) {
        Level level = useOnContext.m_43725_();
        if (!level.f_46443_) {
            InteractionHand hand = useOnContext.m_43724_();
            ItemStack stack = useOnContext.m_43723_().m_21120_(hand);
            BlockPos blockPos = ItemSpawnEgg.correctPosition(useOnContext.m_8083_(), useOnContext.m_43719_());
            ItemSpawnEgg.activate(stack, level, blockPos);
            if (!useOnContext.m_43723_().m_7500_()) {
                stack.m_41774_(1);
            }
        }
        return InteractionResult.PASS;
    }

    public void m_7373_(@NotNull ItemStack itemStack, @Nullable Level level, @NotNull List<Component> components, @NotNull TooltipFlag tooltipFlag) {
        super.m_7373_(itemStack, level, components, tooltipFlag);
        ChickenStats chickenStats = new ChickenStats(itemStack);
        if (Screen.m_96638_()) {
            components.add((Component)new TranslatableComponent("entity.ChickensChicken.top.growth").m_130946_(" " + chickenStats.getGrowth()).m_130940_(ChatFormatting.DARK_PURPLE));
            components.add((Component)new TranslatableComponent("entity.ChickensChicken.top.gain").m_130946_(" " + chickenStats.getGain()).m_130940_(ChatFormatting.DARK_PURPLE));
            components.add((Component)new TranslatableComponent("entity.ChickensChicken.top.strength").m_130946_(" " + chickenStats.getStrength()).m_130940_(ChatFormatting.DARK_PURPLE));
        } else {
            components.add((Component)new TranslatableComponent("gui.hold.shift.tooltip"));
        }
    }

    @NotNull
    public Component m_7626_(@NotNull ItemStack stack) {
        ChickensRegistryItem chickenDescription = ChickensRegistry.getByRegistryName(ItemChicken.getTypeFromStack(stack));
        if (chickenDescription == null) {
            return new TextComponent("Any Chicken");
        }
        return new TranslatableComponent("entity.chickens." + chickenDescription.getEntityName());
    }

    public static void applyEntityIdToItemStack(ItemStack stack, ResourceLocation entityId) {
        CompoundTag nbttagcompound = stack.m_41782_() ? stack.m_41783_() : new CompoundTag();
        CompoundTag nbttagcompound1 = new CompoundTag();
        nbttagcompound1.m_128359_("id", entityId.toString());
        nbttagcompound.m_128365_("ChickenType", (Tag)nbttagcompound1);
        stack.m_41751_(nbttagcompound);
    }

    @javax.annotation.Nullable
    public static String getTypeFromStack(ItemStack stack) {
        CompoundTag nbttagcompound = stack.m_41783_();
        if (nbttagcompound != null && nbttagcompound.m_128425_("ChickenType", 10)) {
            new CompoundTag();
            CompoundTag chickentag = nbttagcompound.m_128469_("ChickenType");
            return chickentag.m_128461_("id");
        }
        return null;
    }

    public void initializeClient(Consumer<IItemRenderProperties> consumer) {
        consumer.accept(new IItemRenderProperties(){

            public BlockEntityWithoutLevelRenderer getItemStackRenderer() {
                return RenderChickenItem.getInstance();
            }
        });
    }
}

